<?php

namespace AdminBundle\Datagrid;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class UserDatagrid
{
    protected $container;
    protected $datagrid;

    public function __construct($container)
    {
        $this->container = $container;

        return $this->datagrid = $container->get('doctrine.datagrid.factory')
            ->create('user', array('multi_sort' => false))
            ->select(array('user'))
            ->id('user.id')
            ->query(function($qb){
                $qb->from('AppBundle:User', 'user');
                return $qb;
            })
            ->filter('first_name', TextType::class, array(
                'attr' => [
                    'placeholder' => "Prénom"
                ],
                'required' => false,
                'label' => "Prénom"
            ), function($value, $qb) {
                return $qb->andWhere('user.firstName LIKE :firstName')
                    ->setParameter('firstName', '%'.$value.'%');
            }
            )
            ->filter('last_name', TextType::class, array(
                'attr' => [
                    'placeholder' => "Nom"
                ],
                'required' => false,
                'label' => "Nom"
            ), function($value, $qb) {
                return $qb->andWhere('user.lastName LIKE :lastName')
                    ->setParameter('lastName', '%'.$value.'%');
            }
            )
            ->filter('email', EmailType::class, array(
                'attr' => [
                    'placeholder' => "Email"
                ],
                'required' => false,
                'label' => "Email"
            ), function($value, $qb) {
                return $qb->andWhere('user.email LIKE :email')
                    ->setParameter('email', '%'.$value.'%');
            }
            )
            ->setDefaultSort(['user.id' => 'desc'])
            ->setDefaultMaxPerPage(30)
            ;
    }

    public function execute()
    {
        return $this->datagrid->execute();
    }

    public function export($format, $params = array())
    {
        return $this->datagrid->export($format, $params);
    }

    public function getAllResults()
    {
        return $this->datagrid->getAllResults();
    }
}