<?php

namespace AdminBundle\Datagrid;

use AppBundle\Entity\RefOrderStatus;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;

class OrderDatagrid
{
    protected $container;
    protected $datagrid;

    public function __construct($container)
    {
        $this->container = $container;

        return $this->datagrid = $container->get('doctrine.datagrid.factory')
            ->create('orderObject', array('multi_sort' => false))
            ->select(array('orderObject'))
            ->id('orderObject.id')
            ->query(function($qb){
                $qb->from('AppBundle:Order', 'orderObject')
                    ->leftJoin('orderObject.status', 'status')
                ;
                return $qb;
            })
            ->filter('id', NumberType::class, array(
                'attr' => [
                    'placeholder' => "#"
                ],
                'required' => false,
                'label' => "#"
            ), function($value, $qb) {
                return $qb->andWhere('orderObject.id = :idVal')
                    ->setParameter('idVal', $value);
            }
            )
            ->filter('status', EntityType::class, array(
                'attr' => [
                    'placeholder' => "Statut"
                ],
                'class' => RefOrderStatus::class,
                'required' => false,
                'choice_label' => 'label',
                'label' => "Type"
            ), function($value, $qb) {
                return $qb->andWhere('status.id = :id')
                    ->setParameter('id', $value);
            }
            )
            ->setDefaultSort(['orderObject.id' => 'desc'])
            ->setDefaultMaxPerPage(30)
            ;
    }

    public function execute()
    {
        return $this->datagrid->execute();
    }

    public function getAllResults()
    {
        return $this->datagrid->getAllResults();
    }
}