<?php
namespace AdminBundle\Datagrid\Export;

use Spyrit\Bundle\DoctrineDatagridBundle\Datagrid\Export\CsvExport;

class ErpCsvExport extends CsvExport
{
    public function getFilename()
    {
        return 'export-erps'.date('d-m-Y H\hi').'.csv';
    }

    public function getHeader()
    {
        return [
            'Société',
            'Adresse société',
            'Adresse compl (société)',
            'Code postal société',
            'Ville société',
            'Type de compte',
            'Nom du contact',
            'Nom ERP',
            'SIRET ERP',
            'Adresse ERP',
            'Compl ERP',
            'Code postal ERP',
            'Ville ERP',
            'Catégorie ERP',
            'Type ERP',
            'En ligne'
        ];
    }

    public function getRow($object)
    {
        $online = 'Non';
        if($object->getSubscriptions()){
            foreach($object->getSubscriptions() as $subscription)
            {
                if($subscription->isValid()){
                    $online = 'Oui';
                }
                break;
            }
        }

        $contactName = '';
        foreach($object->getCompany()->getUsers() as $user)
        {
            $contactName = $user->getFirstName().' '.$user->getLastName();
            break;
        }

        if($object->getCompany()->getRole() == 'large'){
            $role = 'Grand compte';
        }else{
            $role = 'Compte standard';
        }

        return [
            $object->getCompany()->getName(),
            $object->getCompany()->getAddress1(),
            $object->getCompany()->getAddress2(),
            $object->getCompany()->getPostalCode(),
            $object->getCompany()->getCity(),
            $role,
            $contactName,
            $object->getName(),
            $object->getSiret(),
            $object->getAddress1(),
            $object->getAddress2(),
            $object->getPostalCode(),
            $object->getCity(),
            $object->getCategoryErp()->getLabel(),
            $object->getTypeErp()->getLabel(),
            $online
        ];

    }

    public function postExecute()
    {
        $this->qb
            ->select(
                'erp')
            ->groupBy('erp.id');
        return $this;
    }
}