<?php
namespace AdminBundle\Datagrid\Export;

use Spyrit\Bundle\DoctrineDatagridBundle\Datagrid\Export\CsvExport;

class ClientCsvExport extends CsvExport
{
    public function getFilename()
    {
        return 'export-clients'.date('d-m-Y H\hi').'.csv';
    }

    public function getHeader()
    {
        return [
            'N°',
            'Nom',
            'SIREN',
            'Adresse',
            'Compl',
            'Ville',
            'Code postal',
            'Type'
        ];
    }

    public function getRow($object)
    {
        if($object->getRole() == 'large'){
            $role = 'Grand compte';
        }else{
            $role = 'Compte standard';
        }


        return [
            $object->getId(),
            $object->getName(),
            $object->getSiren(),
            $object->getAddress1(),
            $object->getAddress2(),
            $object->getCity(),
            $object->getPostalCode(),
            $role
        ];

    }

    public function postExecute()
    {
        $this->qb
            ->select(
                'company')
            ->groupBy('company.id');
        return $this;
    }
}