<?php

namespace AdminBundle\Datagrid;

use AdminBundle\Datagrid\Export\ErpCsvExport;
use AppBundle\Entity\RefCategoryErp;
use AppBundle\Entity\RefTypeErp;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class ErpDatagrid
{
    protected $container;
    protected $datagrid;

    public function __construct($container)
    {
        $this->container = $container;

        return $this->datagrid = $container->get('doctrine.datagrid.factory')
            ->create('erp', array('multi_sort' => false))
            ->select(array('erp'))
            ->id('erp.id')
            ->query(function($qb){
                $qb->from('AppBundle:Erp', 'erp')
                    ->leftJoin('erp.company', 'company')
                    ->leftJoin('erp.categoryErp', 'category')
                    ->leftJoin('erp.typeErp', 'type')
                    ->leftJoin('erp.subscriptions', 'subscription');
                return $qb;
            })
            ->filter('name', TextType::class, array(
                'attr' => [
                    'placeholder' => "Nom"
                ],
                'required' => false,
                'label' => "Nom"
            ), function($value, $qb) {
                return $qb->andWhere('erp.name LIKE :name')
                    ->setParameter('name', '%'.$value.'%');
            }
            )
            ->filter('category', EntityType::class, array(
                'attr' => [
                    'placeholder' => "Catégorie"
                ],
                'class' => RefCategoryErp::class,
                'required' => false,
                'choice_label' => 'label',
                'label' => "Catégorie"
            ), function($value, $qb) {
                return $qb->andWhere('category.id = :id')
                    ->setParameter('id', $value);
            }
            )
            ->filter('type', EntityType::class, array(
                'attr' => [
                    'placeholder' => "Type"
                ],
                'class' => RefTypeErp::class,
                'required' => false,
                'choice_label' => 'label',
                'label' => "Type"
            ), function($value, $qb) {
                return $qb->andWhere('type.id = :id')
                    ->setParameter('id', $value);
            }
            )
            ->filter('company', TextType::class, array(
                'attr' => [
                    'placeholder' => "Société"
                ],
                'required' => false,
                'label' => "Société"
            ), function($value, $qb) {
                return $qb->andWhere('company.name LIKE :name')
                    ->setParameter('name', '%'.$value.'%');
            }
            )
            ->filter('city', TextType::class, array(
                'attr' => [
                    'placeholder' => "Ville ou code postal"
                ],
                'required' => false,
                'label' => "Ville"
            ), function($value, $qb) {
                return $qb->andWhere('erp.city LIKE :city OR erp.postalCode LIKE :city')
                    ->setParameter('city', '%'.$value.'%');
            }
            )
            ->filter('subscription', ChoiceType::class, array(
                'attr' => [
                    'placeholder' => "En ligne"
                ],
                'choices' => [
                    'En ligne' => "enligne",
                    'Hors ligne' => "horsligne"
                ],
                'required' => false,
                'label' => "Ville"
            ), function($value, $qb) {
                return $qb->andWhere(
                    ':value = :enligne AND subscription.date_end > :date OR
                :value = :horsligne AND subscription.date_end < :date OR
                :value = :horsligne AND subscription.date_end is NULL'
                )
                    ->setParameter('date', new \DateTime('-5 second'), \Doctrine\DBAL\Types\Type::DATETIME)
                    ->setParameter('value', $value)
                    ->setParameter('enligne', 'enligne')
                    ->setParameter('horsligne', 'horsligne');
            }
            )
            ->setDefaultSort(['erp.id' => 'desc'])
            ->setDefaultMaxPerPage(30)
            ->setExports([
                'csv' => ErpCsvExport::class
            ])
            ;
    }

    public function execute()
    {
        return $this->datagrid->execute();
    }

    public function export($format, $params = array())
    {
        return $this->datagrid->export($format, $params);
    }

    public function getAllResults()
    {
        return $this->datagrid->getAllResults();
    }
}