<?php

namespace AdminBundle\Datagrid;

use AdminBundle\Datagrid\Export\ClientCsvExport;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class ClientDatagrid
{
    protected $container;
    protected $datagrid;

    public function __construct($container)
    {
        $this->container = $container;

        return $this->datagrid = $container->get('doctrine.datagrid.factory')
            ->create('company', array('multi_sort' => false))
            ->select(array('company'))
            ->id('company.id')
            ->query(function($qb){
                $qb->from('AppBundle:Company', 'company');
                return $qb;
            })
            ->filter('name', TextType::class, array(
                'attr' => [
                    'placeholder' => "Nom"
                ],
                'required' => false,
                'label' => "Nom"
            ), function($value, $qb) {
                return $qb->andWhere('company.name LIKE :name')
                    ->setParameter('name', '%'.$value.'%');
            }
            )
            ->filter('city', TextType::class, array(
                'attr' => [
                    'placeholder' => "Ville ou code postal"
                ],
                'required' => false,
                'label' => "Ville"
            ), function($value, $qb) {
                return $qb->andWhere('company.city LIKE :city OR company.postalCode LIKE :city')
                    ->setParameter('city', '%'.$value.'%');
            }
            )
            ->filter('role', ChoiceType::class, array(
                'required' => false,
                'choices' => [
                    'Compte standard' => 'standard',
                    'Grand compte' => 'large'
                ],
                'placeholder' => 'Type de compte'
            ), function($value, $qb) {
                return $qb->andWhere('company.role = :role')
                    ->setParameter('role', $value);
            }
            )
            ->setDefaultSort(['company.id' => 'desc'])
            ->setDefaultMaxPerPage(30)
            ->setExports([
                'csv' => ClientCsvExport::class
            ])
            ;
    }

    public function execute()
    {
        return $this->datagrid->execute();
    }

    public function export($format, $params = array())
    {
        return $this->datagrid->export($format, $params);
    }

    public function getAllResults()
    {
        return $this->datagrid->getAllResults();
    }
}