<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\UserDatagrid;
use AdminBundle\Form\AdminCompanyCoinsType;
use AdminBundle\Form\AdminEditUserPasswordType;
use AdminBundle\Form\AdminUserType;
use AppBundle\Entity\CoinsHistory;
use AppBundle\Entity\Company;
use AppBundle\Entity\User;
use FrontBundle\Form\EditUserInfoType;
use FrontBundle\Form\EditUserPasswordType;
use FrontBundle\Form\UserType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Core\Tests\Encoder\PasswordEncoder;

class UserController extends Controller
{
    /**
     * @Route("/admin/user/show/{user_id}", name="user_show")
     */
    public function userShowAction(Request $request, $user_id)
    {

        $user = $this->getDoctrine()->getRepository(User::class)
            ->findOneBy(
                ['id' => $user_id]
            );

        $company = $this->getDoctrine()->getRepository(Company::class)
            ->findOneBy(['id' => $user->getCompany()->getId()]);

        $coinsHistory = $this->getDoctrine()->getRepository(CoinsHistory::class)->findBy([
            'company' => $company
        ], ['date' => 'DESC']);

        $form = $this->createForm(AdminCompanyCoinsType::class, $user->getCompany());

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $actual_amount = $company->getCoins();
            $operation = $form->get('operation')->getData();
            $new_amount = $form->get('coins')->getData();

            $new_balance = null;
            if($operation == '-'){
                $new_balance = $actual_amount - $new_amount;
            }
            if($operation == '+'){
                $new_balance = $actual_amount + $new_amount;
            }

            $oldBalance = $company->getCoins();
            if(is_null($company->getCoins())){
                $oldBalance = 0;
            }

            if($new_balance < 0) {
                $this->addFlash('danger', "Erreur, le montant de crédits ne peut pas être négatif.");
                return $this->redirectToRoute('user_show', [
                    'user_id' => $user_id
                ]);
            }

            $coinsHistory = new CoinsHistory();
            $coinsHistory->setUser($this->getUser())
                ->setCompany($company)
                ->setMovementType('manual')
                ->setOperation($operation.$new_amount)
                ->setOldBalance($oldBalance)
                ->setNewBalance($new_balance);


            $company->setCoins($new_balance);

            $em = $this->getDoctrine()->getManager();
            $em->persist($coinsHistory);
            $em->persist($company);
            $em->flush();

            $this->addFlash('success', "Les crédits ont bien été modifiés");

            return $this->redirectToRoute('user_show', [
                'user_id' => $user_id
            ]);

        }

        return $this->render('Admin/User/show.html.twig', [
            'user' => $user,
            'coinsHistory' => $coinsHistory,
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/user/list", name="admin_user_list")
     */
    public function userListAction(Request $request)
    {
        $datagrid = new UserDatagrid($this->container);

        return $this->render('Admin/User/list.html.twig', [
            'datagrid' => $datagrid->execute()
        ]);
    }

    /**
     * @Route("/admin/user/create", name="admin_user_create")
     */
    public function userCreateAction(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {

        $user = new User();

        $form = $this->createForm(AdminUserType::class, $user);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $password = $passwordEncoder->encodePassword($user, $user->getPlainPassword());
            $user->setPassword($password);
            $user->setStatut('enabled')
            ->setRole('ROLE_USER');

            $em = $this->getDoctrine()->getManager();
            $em->persist($user);
            $em->flush();

            $this->addFlash('notice', 'Le compte a bien été créé.');

            return $this->redirectToRoute('user_show', ['user_id' => $user->getId()]);
        }

        return $this->render('Admin/User/create.html.twig', [
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/user/edit/{user_id}", name="admin_user_edit")
     */
    public function userEditAction(Request $request, $user_id, UserPasswordEncoderInterface $passwordEncoder)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->findOneBy([
            'id' => $user_id
        ]);


        // General informations
        $form_user = $this->createForm(EditUserInfoType::class, $user);
        $form_user->handleRequest($request);
        if ($form_user->isSubmitted() && $form_user->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($user);
            $em->flush();
            $this->addFlash('notice', "Les données de l'utilisateur ont bien été modifiées.");
            return $this->redirectToRoute('admin_user_edit', ['user_id' => $user_id]);
        }

        // Password
        $form_password = $this->createForm(AdminEditUserPasswordType::class, $user);
        $form_password->handleRequest($request);
        if ($form_password->isSubmitted() && $form_password->isValid()) {
            $em = $this->getDoctrine()->getManager();

            $password = $passwordEncoder->encodePassword($this->getUser(), $user->getPlainPassword());
            $user->setPassword($password);
            $em->persist($user);
            $em->flush();
            $this->addFlash('notice', "Le mot de passe de l'utilisateur a bien été modifié.");

            return $this->redirectToRoute('admin_user_edit', ['user_id' => $user_id]);

        }

        return $this->render('Admin/User/edit.html.twig', [
            'user' => $user,
            'form_user' => $form_user->createView(),
            'form_password' => $form_password->createView()
        ]);
    }


    /**
     * @Route("/admin/user/delete/{user_id}", name="admin_user_delete")
     */
    public function userDeleteAction(Request $request, $user_id)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->findOneBy([
            'id' => $user_id
        ]);

        $em = $this->getDoctrine()->getManager();

        $em->remove($user);
        $em->flush();

        $this->addFlash('success', "L'utilisateur a bien été supprimé.");
        return $this->redirectToRoute('admin_user_list');
    }


}
