<?php

namespace AdminBundle\Controller;

use AdminBundle\Form\QrCodeRequestType;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\QrCode;
use AppBundle\Entity\QrCodeRequest;
use AppBundle\Entity\RefPrintStatus;
use AppBundle\Service\MailManager;
use FrontBundle\Form\PrintRequestType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class QrCodeRequestController extends Controller
{
    /**
     * @Route("/admin/qrcoderequest/list", name="qrcode_request_list")
     */
    public function qrCodeRequestListAction(Request $request)
    {
        $qrCodeRequests = $this->getDoctrine()->getRepository(QrCodeRequest::class)->findBy(['status' => 'pending'], ['created_at' => 'DESC']);
        return $this->render('Admin/QrCodeRequest/list.html.twig', [
            'qrCodeRequests' => $qrCodeRequests
        ]);
    }

    /**
     * @Route("/admin/qrcoderequest/show/{qrcode_request_id}", name="qrcode_request_show")
     */
    public function printRequestShowAction(Request $request, $qrcode_request_id, MailManager $mailManager)
    {
        $qrcodeRequest = $this->getDoctrine()->getRepository(QrCodeRequest::class)->findOneBy([
            'id' => $qrcode_request_id
        ]);

        $form = $this->createForm(QrCodeRequestType::class, $qrcodeRequest);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $register = $qrcodeRequest->getRegister();

            if($request->request->get('qr_code_request')['status']){
                $status = $request->request->get('qr_code_request')['status'];

                if($status == 'send'){
                    $mailManager->sendQrCodePrintConfirmationEmail($qrcodeRequest->getOrder());
                }

                $qrcodeRequest->setUpdatedAt(new \DateTime());
                $em = $this->getDoctrine()->getManager();
                $em->persist($qrcodeRequest);
                $em->flush();

            }


            return $this->redirectToRoute('qrcode_request_show', [
                'qrcode_request_id' => $qrcodeRequest->getId()
            ]);

        }

        return $this->render('Admin/QrCodeRequest/show.html.twig', [
            'qrCodeRequest' => $qrcodeRequest,
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/qrcodes/export", name="qrcodes_export")
     */
    public function qrCodesExportAction(Request $request)
    {
        $min = (intval($request->get('min')) ?: 1000);
        $max = (intval($request->get('max')) ?: 5000);
        $qrCodes = $this->getDoctrine()->getRepository(QrCode::class)->findByHashRange($min, $max);

        $files = array();

        foreach ($qrCodes as $qrCode) {
            array_push($files, 'qrcodes/pdf/'.$qrCode->getPdf());
        }

        $zip = new \ZipArchive();
        $zipName = 'QrCodes_'.time().".zip";
        $zip->open($zipName,  \ZipArchive::CREATE);
        foreach ($files as $f) {
            $zip->addFromString(basename($f),  file_get_contents($f));
        }
        $zip->close();

        $response = new Response(file_get_contents($zipName));
        $response->headers->set('Content-Type', 'application/zip');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $zipName . '"');
        $response->headers->set('Content-length', filesize($zipName));

        return $response;
    }
}
