<?php

namespace AdminBundle\Controller;

use AppBundle\Entity\RefPrinter;
use FrontBundle\Form\PrinterType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class PrinterController extends Controller
{
    /**
     * @Route("/admin/printers/list", name="printer_list")
     */
    public function printerListAction(Request $request)
    {

        $printers = $this->getDoctrine()->getRepository(RefPrinter::class)->findAll();
        return $this->render('Admin/Printer/list.html.twig', [
            'printers' => $printers
        ]);
    }

    /**
     * @Route("/admin/printers/create", name="printer_create")
     */
    public function printerCreateAction(Request $request)
    {

        $printer = new RefPrinter();

        $form = $this->createForm(PrinterType::class, $printer);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($printer);
            $em->flush();

            $this->addFlash('notice', 'L\'imprimeur a bien été créé.');

            return $this->redirectToRoute('printer_list');
        }

        return $this->render('Admin/Printer/create.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/admin/printers/edit/{printer_id}", name="printer_edit")
     */
    public function printerEditAction(Request $request, $printer_id)
    {

        $printer = $this->getDoctrine()->getRepository(RefPrinter::class)
            ->findOneBy(['id' => $printer_id]);


        $form = $this->createForm(PrinterType::class, $printer);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($printer);
            $em->flush();

            $this->addFlash('notice', 'L\'imprimeur a bien été modifié.');

            return $this->redirectToRoute('printer_list');
        }

        return $this->render('Admin/Printer/edit.html.twig', [
            'form' => $form->createView(),
        ]);
    }

}
