<?php

namespace AdminBundle\Controller;

use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\RefPrinter;
use AppBundle\Entity\RefPrintStatus;
use AppBundle\Service\MailManager;
use FrontBundle\Form\PrinterType;
use FrontBundle\Form\PrintRequestType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class PrintRequestController extends Controller
{
    /**
     * @Route("/admin/printrequest/list", name="print_request_list")
     */
    public function printRequestListAction(Request $request)
    {
        $printRequests = $this->getDoctrine()->getRepository(PrintRequest::class)->findByEligibleRegister();
        return $this->render('Admin/PrintRequest/list.html.twig', [
            'printRequests' => $printRequests
        ]);
    }

    /**
     * @Route("/admin/printrequest/show/{print_request_id}", name="print_request_show")
     */
    public function printRequestShowAction(Request $request, $print_request_id, MailManager $mailManager)
    {
        $printRequest = $this->getDoctrine()->getRepository(PrintRequest::class)->findOneBy([
            'id' => $print_request_id
        ]);

        $form = $this->createForm(PrintRequestType::class, $printRequest);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {


            $status = $this->getDoctrine()->getRepository(RefPrintStatus::class)->findOneBy([
                'id' => 2
            ]);

            # GENERATE UNIQUE TOKEN FOR PDFS
            $register = $printRequest->getRegister();

            $chars = "abcdefghkmnprstuvwxyzABCDEFGHKMNPRSTUVWXYZ23456789";
            $token = substr(str_shuffle($chars), 0, 16);
            $register->setToken($token);
            $em = $this->getDoctrine()->getManager();
            $em->persist($register);
            $em->flush();

            # Envoi du mail pour l'imprimeur
            $mailManager->sendPrinterRequestEmail($printRequest->getPrinter(), $register);

            # Envoi du mail pour le client
            $mailManager->sendPrintConfirmationEmail($printRequest->getOrder());


            $printRequest->setRefPrintStatus($status);

            $this->addFlash('notice', "La demande d'impression a bien été envoyée");

            $em = $this->getDoctrine()->getManager();
            $em->persist($printRequest);
            $em->flush();

            return $this->redirectToRoute('print_request_show', [
                'print_request_id' => $printRequest->getId()
            ]);

        }

        return $this->render('Admin/PrintRequest/show.html.twig', [
            'printRequest' => $printRequest,
            'form' => $form->createView()
        ]);
    }

}
