<?php

namespace AdminBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\NavigationMenu;
use AppBundle\Entity\Post;
use FrontBundle\Form\PostType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class PostController extends Controller
{
    /**
     * @Route("/admin/post/list", name="admin_post_list")
     */
    public function postListAction(Request $request)
    {
        $posts = $this->getDoctrine()->getRepository(Post::class)->findAll();

        return $this->render('Admin/Post/list.html.twig', [
            'posts' => $posts,
        ]);
    }

    /**
     * @Route("/admin/post/create", name="admin_post_create")
     */
    public function postCreateAction(Request $request)
    {

        $post = new Post();
        $form = $this->createForm(PostType::class, $post);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();

            $em->persist($post);
            $em->flush();

            $this->addFlash('notice', 'La page a bien crée.');

            return $this->redirectToRoute('admin_post_edit', ['post_id' => $post->getId()]);

        }

        return $this->render('Admin/Post/create.html.twig', [
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/post/edit/{post_id}", name="admin_post_edit")
     */
    public function postEditAction(Request $request, $post_id)
    {
        $post = $this->getDoctrine()->getRepository(Post::class)->findOneBy([
            'id' => $post_id
        ]);

        $form = $this->createForm(PostType::class, $post);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($post);
            $em->flush();

            $this->addFlash('notice', 'La page a bien été éditée.');

            return $this->redirectToRoute('admin_post_edit', ['post_id' => $post_id]);

        }

        return $this->render('Admin/Post/edit.html.twig', [
            'post' => $post,
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/post/delete/{post_id}", name="admin_post_delete")
     */
    public function postDeleteAction($post_id)
    {
        $post = $this->getDoctrine()->getRepository(Post::class)->findOneBy([
            'id' => $post_id
        ]);

        $em = $this->getDoctrine()->getManager();
        $em->remove($post);
        $em->flush();

        $this->addFlash('notice', 'La page a bien été supprimée.');

        return $this->redirectToRoute('admin_post_list', ['post_id' => $post_id]);

    }

}
