<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\OrderDatagrid;
use AdminBundle\Datagrid\OrderDemandsDatagrid;
use AppBundle\Entity\Order;
use AppBundle\Entity\RefPrinter;
use AppBundle\Entity\Relance;
use AppBundle\Service\MailManager;
use FrontBundle\Form\PrinterType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class OrderController extends Controller
{

    /**
     * @Route("/admin/order/list", name="admin_order_list")
     */
    public function orderListAction(Request $request)
    {
        $datagrid = new OrderDatagrid($this->container);
        return $this->render('Admin/Order/list.html.twig', [
            'datagrid' => $datagrid->execute(),
        ]);
    }

    /**
     * @Route("/admin/order/demands/list", name="admin_order_demands_list")
     */
    public function orderDemandsListAction(Request $request)
    {
        $datagrid = new OrderDemandsDatagrid($this->container);
        return $this->render('Admin/Order/OrderDemands/list.html.twig', [
            'datagrid' => $datagrid->execute(),
        ]);
    }

    /**
     * @Route("/admin/order/show/{order_id}", name="admin_order_show")
     */
    public function orderShowAction(Request $request, $order_id)
    {
        $order = $this->getDoctrine()->getRepository(Order::class)->findOneBy([
            'id' => $order_id
        ]);

        return $this->render('Admin/Order/show.html.twig', [
            'order' => $order
        ]);
    }

    /**
     * @Route("/admin/order/relance/{order_id}", name="admin_order_relance")
     */
    public function orderRelanceAction(Request $request, $order_id, MailManager $mailManager)
    {
        $order = $this->getDoctrine()->getRepository(Order::class)->findOneBy([
            'id' => $order_id
        ]);

        if($order->getStatus()->getId() == 3) {
            $this->addFlash('warning', "Vous ne pouvez pas utiliser le module de relance sur une commmande validée.");
            return $this->redirectToRoute('admin_order_show', ['order_id' => $order_id]);
        }

        $mailManager->sendOrderRelanceEmail($order);
        $relance = new Relance();
        $relance
            ->setUser($this->getUser())
            ->setOrder($order)
        ;

        $em = $this->getDoctrine()->getManager();

        $em->persist($relance);
        $em->flush();

        $this->addFlash('success', "L'email de relance a bien été envoyé.");
        return $this->redirectToRoute('admin_order_show', ['order_id' => $order_id]);
    }


}
