<?php

namespace AdminBundle\Controller;

use AdminBundle\Form\NavigationMenuType;
use AppBundle\Entity\NavigationMenu;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

class NavigationMenuController extends Controller
{
    /**
     * @Route("/admin/menu/edit/order", name="menu_edit_order")
     */
    public function navigationMenuEditOrderAction(Request $request)
    {
        if($request->isXmlHttpRequest()) {
            $content = $request->getContent();
            $em = $this->getDoctrine()->getManager();
            $response = new Response();

            if(!empty($content))
            {
                $param = json_decode($request->getContent(), true);

                foreach($param['items'] as $item)
                {
                    $menu_item = $this->getDoctrine()->getRepository(NavigationMenu::class)->findOneBy([
                        'id' => $item['id']
                    ]);
                    $menu_item->setOrder($item['order']);
                    $em->persist($menu_item);
                    $em->flush();
                    $data = json_encode('ok');
                }
            }
            else
            {
                $data = json_encode('ko');
            }
            $response->headers->set('Content-Type', 'application/json');
            $response->setContent($data);

            return $response;
        }
        return null;
    }

    /**
     * @Route("/admin/menu/delete/{item_id}", name="menu_delete")
     */
    public function navigationMenuCreateAction(Request $request, $item_id)
    {
        $menu_item = $this->getDoctrine()->getRepository(NavigationMenu::class)->findOneBy([
            'id' => $item_id
        ]);

        $em = $this->getDoctrine()->getManager();
        $em->remove($menu_item);
        $em->flush();

        return $this->redirectToRoute('menu_show');
    }

    /**
     * @Route("/admin/menu/show", name="menu_show")
     */
    public function navigationMenuShowAction(Request $request)
    {

        $nav = $this->getDoctrine()->getRepository(NavigationMenu::class)->findBy([], ['order' => 'ASC']);

        $navigation_item = new NavigationMenu();
        $form_create = $this->createForm(NavigationMenuType::class, $navigation_item);

        $form_create->handleRequest($request);
        if ($form_create->isSubmitted() && $form_create->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $navigation_item->setOrder(10);
            $em->persist($navigation_item);

            $em->flush();

            $this->addFlash('notice', 'L\'élément de navigation a bien été créé.');

            return $this->redirectToRoute('menu_show');
        }

        return $this->render('Admin/Navigation/show.html.twig', [
            'menu' => $nav,
            'form_create' => $form_create->createView()
        ]);
    }
}
