<?php

namespace AdminBundle\Controller;

use AdminBundle\Form\MydlCheckType;
use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Exchange;
use AppBundle\Entity\RefPrinter;
use AppBundle\Service\MailManager;
use FrontBundle\Form\PrinterType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class MydlCheckController extends Controller
{
    /**
     * @Route("/admin/mydlcheck/list", name="mydl_check_list")
     */
    public function mydlCheckListAction(Request $request)
    {

        $registers = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findByValidationRegister();

        return $this->render('Admin/MydlCheck/list.html.twig', [
            'registers' => $registers
        ]);
    }

    /**
     * @Route("/admin/mydlcheck/show/{register_id}", name="mydl_check_show")
     */
    public function mydlCheckShowAction(Request $request, $register_id, MailManager $mailManager)
    {

        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneBy([
            'id' => $register_id
        ]);

        $types = null;
        $fileUploads = null;

        $types = $register->getErp()->getCategoryErp()->getTypesFile();
        $fileUploads = [];
        foreach($types as $type) {
            $fileUploads[$type->getId()] = $register->getFileUploadsByTypeId($type->getId());
        }

        $exchange = new Exchange();
        $form = $this->createForm(MydlCheckType::class, $exchange);

        $form->handleRequest($request);
        if($form->isValid() && $form->isSubmitted()){

            $em = $this->getDoctrine()->getManager();
            $exchange->setRegister($register);
            $register->setValidationStatus($request->request->get('mydl_check')['status'])
                ->setCheckedAt(new \DateTime());
            $em->persist($exchange);
            $em->persist($register);
            $em->flush();


            $users = $register->getErp()->getCompany()->getUsers();

            $final_user = null;
            foreach($users as $user)
            {
                $final_user = $user;
                break;
            }

            $mailManager->sendMydlCheckEmail($register, $exchange, $final_user);
            $this->addFlash('success', 'La demande de vérification a bien été mise à jour');

            return $this->redirectToRoute('mydl_check_show', ['register_id' => $register_id]);
        }

        return $this->render('Admin/MydlCheck/show.html.twig', [
            'register' => $register,
            'types' => $types,
            'fileUploads' => $fileUploads,
            'form' => $form->createView()
        ]);
    }

}
