<?php

namespace AdminBundle\Controller;

use AdminBundle\Form\AdminMailTypeType;
use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Erp;
use AppBundle\Entity\MailType;
use AppBundle\Entity\User;
use Proxies\__CG__\AppBundle\Entity\Company;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class MailTypeController extends Controller
{
    /**
     * @Route("/admin/mailtype/list", name="admin_mailtype_list")
     */
    public function mailtypeListAction(Request $request)
    {
        $mailstypes = $this->getDoctrine()->getRepository(MailType::class)->findBy([],['created_at' => 'DESC']);

        return $this->render('Admin/MailType/list.html.twig', [
            'mailstypes' => $mailstypes
        ]);
    }

    /**
     * @Route("/admin/mailtype/create", name="admin_mailtype_create")
     */
    public function mailtypeCreateAction(Request $request)
    {
        $mailtype = new MailType();

        $form = $this->createForm(AdminMailTypeType::class, $mailtype);

        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em = $this->getDoctrine()->getManager();
            $em->persist($mailtype);
            $em->flush();

            $this->addFlash('success', 'L\'email type a bien été créé.');
            return $this->redirectToRoute('admin_mailtype_show', ['id' => $mailtype->getId()]);
        }

        return $this->render('Admin/MailType/create.html.twig', [
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/mailtype/show/{id}", name="admin_mailtype_show")
     */
    public function mailtypeShowAction(Request $request, $id)
    {
        $mailtype = $this->getDoctrine()->getRepository(MailType::class)->findOneBy(['id' => $id]);

        $form = $this->createForm(AdminMailTypeType::class, $mailtype);

        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em = $this->getDoctrine()->getManager();
            $em->persist($mailtype);
            $em->flush();

            $this->addFlash('success', 'L\'email type a bien été modifié.');
            return $this->redirectToRoute('admin_mailtype_show', ['id' => $id]);
        }

        return $this->render('Admin/MailType/show.html.twig', [
            'mailtype' => $mailtype,
            'form' => $form->createView()
        ]);
    }
}
