<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\ClientDatagrid;
use AdminBundle\Datagrid\ErpDatagrid;
use AdminBundle\Form\AdminMailType;
use AppBundle\Entity\Company;
use AppBundle\Entity\Mail;
use AppBundle\Entity\MailType;
use AppBundle\Service\MailManager;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class MailController extends Controller
{
    /**
     * @Route("/admin/mail/{type}/send/{entity}", name="admin_mail_send")
     */
    public function mailGroupSendAction(Request $request, $type, $entity, MailManager $mailManager)
    {

        if($type == 'group'){
            if($entity == 'company'){
                $datagrid = new ClientDatagrid($this->container);
                $companies = $datagrid->getAllResults();
            }elseif($entity == 'erp'){
                $datagrid = new ErpDatagrid($this->container);
                $erps = $datagrid->getAllResults();
                $companies_array = [];
                foreach($erps as $erp)
                {
                    if(!in_array($erp->getCompany()->getId(), $companies_array)){
                        $companies_array[] = $erp->getCompany()->getId();
                    }
                }
                $companies = $this->getDoctrine()->getRepository(Company::class)->findBy([
                    'id' => $companies_array
                ]);
            }else{
                return $this->redirectToRoute('admin_index');
            }
        }elseif($type == 'single'){
            $companies = $this->getDoctrine()->getRepository(Company::class)->findBy([
                'id' => $entity
            ]);
        }else{
            return $this->redirectToRoute('admin_index');
        }


        $mailtypes = $this->getDoctrine()->getRepository(MailType::class)->findBy([], ['name' => 'ASC']);

        $mail = new Mail();
        $form = $this->createForm(AdminMailType::class, $mail);

        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $em = $this->getDoctrine()->getManager();

            $count_emails = 0;
            foreach($companies as $company)
            {
                $mail->addCompany($company);
                $count_emails += count($company->getUsers());
            }
            $mail->setNbOfEmails($count_emails);
            $em->persist($mail);


            # Save in MailType if checked
            if(!empty($request->request->get('admin_mail')['save_as_type'])){
                if(!empty($request->request->get('admin_mail')['save_as_type_name'])){
                    $mailType = new MailType();
                    $mailType->setName($request->request->get('admin_mail')['save_as_type_name'])
                        ->setContent($mail->getContent());
                    $em->persist($mailType);
                }
            }

            $mailManager->sendCustomEmails($mail);

            $em->flush();
            $this->addFlash('success', 'Le(s) email(s) ont bien été envoyé(s).');
            return $this->redirectToRoute('admin_mail_show', ['id' => $mail->getId()]);
        }

        return $this->render('Admin/Mail/create.html.twig', [
            'companies' => $companies,
            'mailtypes' => $mailtypes,
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/mail/list", name="admin_mail_list")
     */
    public function mailListAction(Request $request)
    {
        $mails = $this->getDoctrine()->getRepository(Mail::class)->findBy([],['created_at' => 'DESC']);

        return $this->render('Admin/Mail/list.html.twig', [
            'mails' => $mails
        ]);
    }

    /**
     * @Route("/admin/mail/show/{id}", name="admin_mail_show")
     */
    public function mailShowAction(Request $request, $id)
    {
        $mail = $this->getDoctrine()->getRepository(Mail::class)->findOneBy(['id' => $id]);

        return $this->render('Admin/Mail/show.html.twig', [
            'mail' => $mail
        ]);
    }


}
