<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\ErpDatagrid;
use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Erp;
use FrontBundle\Form\ErpType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ErpController extends Controller
{

    /**
     * @Route("/admin/erp/list", name="admin_erp_list")
     */
    public function adminErpListAction(Request $request)
    {

        $datagrid = new ErpDatagrid($this->container);

        return $this->render('Admin/Erp/list.html.twig', [
            'datagrid' => $datagrid->execute()
        ]);
    }

    /**
     * @Route("/admin/erp/edit/{erp_id}", name="admin_erp_edit")
     */
    public function erpEditAction(Request $request, $erp_id)
    {
        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy([
            'id' => $erp_id
        ]);

        $form = $this->createForm(ErpType::class, $erp);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($erp);
            $em->flush();
            $this->addFlash('notice', "Les données de l'établissement ont bien été modifiées.");
            return $this->redirectToRoute('admin_erp_edit', ['erp_id' => $erp_id]);
        }

        return $this->render('Admin/Erp/edit.html.twig', [
            'erp' => $erp,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/admin/erp/export", name="erp_export")
     */
    public function erpExportAction(Request $request)
    {
        $datagrid = new ErpDatagrid($this->container);

        return $datagrid->export('csv', array('container' => $this->container))->getResponse();
    }

    /**
     * @Route("/admin/erp/show/{erp_id}", name="admin_erp_show")
     */
    public function erpShowAction(Request $request, $erp_id)
    {
        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy(
                ['id' => $erp_id]
        );

        $registers = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findBy(['erp' => $erp],[
            'validated_at' => 'DESC'
        ]);

        return $this->render('Admin/Erp/show.html.twig', [
            'erp' => $erp,
            'registers' => $registers
        ]);
    }


}
