<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\ClientDatagrid;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\QrCodeRequest;
use AppBundle\Entity\User;
use Proxies\__CG__\AppBundle\Entity\Company;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class DefaultController extends Controller
{
    /**
     * @Route("/admin", name="admin_index")
     */
    public function adminAction()
    {

        $datagrid = new ClientDatagrid($this->container);

        return $this->render('Admin/index.html.twig', [
            'datagrid' => $datagrid->execute()
        ]);
    }

    /**
     * @Route("/admin/requests/list", name="admin_requests_list")
     */
    public function requestsListAction()
    {
        $printRequests = $this->getDoctrine()->getRepository(PrintRequest::class)->findByStatusNew();
        $qrCodeRequests = $this->getDoctrine()->getRepository(QrCodeRequest::class)->findByStatusNew();

        $erps = [];
        foreach ($printRequests as $printRequest) {
            $erps[$printRequest->getRegister()->getErp()->getName().' '.$printRequest->getRegister()->getErp()->getId()][] = $printRequest;
        }
        foreach ($qrCodeRequests as $qrCodeRequest) {
            $erps[$qrCodeRequest->getRegister()->getErp()->getName().' '.$qrCodeRequest->getRegister()->getErp()->getId()][] = $qrCodeRequest;
        }

        return $this->render('Admin/Requests/list.html.twig', [
            'erps' => $erps
        ]);
    }

    /**
     * @Route("/admin/requests/history/list", name="admin_requests_history_list")
     */
    public function requestsHistoryListAction()
    {
        $printRequests = $this->getDoctrine()->getRepository(PrintRequest::class)->findByStatusDone();
        $qrCodeRequests = $this->getDoctrine()->getRepository(QrCodeRequest::class)->findByStatusDone();

        $erps = [];
        foreach ($printRequests as $printRequest) {
            $erps[$printRequest->getRegister()->getErp()->getName().' '.$printRequest->getRegister()->getErp()->getId()][] = $printRequest;
        }
        foreach ($qrCodeRequests as $qrCodeRequest) {
            $erps[$qrCodeRequest->getRegister()->getErp()->getName().' '.$qrCodeRequest->getRegister()->getErp()->getId()][] = $qrCodeRequest;
        }

        return $this->render('Admin/Requests/History/list.html.twig', [
            'erps' => $erps
        ]);
    }
}
