<?php

namespace AdminBundle\Controller;

use AdminBundle\Datagrid\ClientDatagrid;
use AdminBundle\Form\AdminCompanyType;
use AppBundle\Entity\Company;
use AppBundle\Entity\Order;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\StreamedResponse;

class CompanyController extends Controller
{
    /**
     * @Route("/admin/company/show/{company_id}", name="company_show")
     */
    public function companyShowAction(Request $request, $company_id)
    {

        $company = $this->getDoctrine()->getRepository(Company::class)
            ->findOneBy(
                ['id' => $company_id]
            );


        $orders = $this->getDoctrine()->getRepository(Order::class)->findBy(
            ['company' => $company], ['created_at' => 'DESC']
        );

        return $this->render('Admin/Company/show.html.twig', [
            'company' => $company,
            'orders' => $orders
        ]);
    }

    /**
     * @Route("/admin/company/edit/{company_id}", name="admin_company_edit")
     */
    public function companyEditAction(Request $request, $company_id)
    {
        $company = $this->getDoctrine()->getRepository(Company::class)->findOneBy([
            'id' => $company_id
        ]);

        $form = $this->createForm(AdminCompanyType::class, $company);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($company);
            $em->flush();
            $this->addFlash('notice', "Les données de la société ont bien été modifiées.");
            return $this->redirectToRoute('admin_company_edit', ['company_id' => $company_id]);
        }


        return $this->render('Admin/Company/edit.html.twig', [
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/admin/company/delete/{company_id}", name="admin_company_delete")
     */
    public function companyDeleteAction($company_id)
    {
        $company = $this->getDoctrine()->getRepository(Company::class)->findOneBy([
            'id' => $company_id
        ]);

        if(count($company->getInvoices()) > 0) {
            $this->addFlash('warning', "La société a des factures liées et ne peut pas être supprimée.");
            return $this->redirectToRoute('admin_index');
        }

        $em = $this->getDoctrine()->getManager();
        $em->remove($company);
        $em->flush();

        $this->addFlash('success', "La société ainsi que les établissements - commandes - utilisateurs lié(e)s ont bien été supprimé(e)s.");
        return $this->redirectToRoute('admin_index');
    }

    /**
     * @Route("/admin/company/export", name="company_export")
     */
    public function exportAction()
    {
        $datagrid = new ClientDatagrid($this->container);

        return $datagrid->export('csv', array('container' => $this->container))->getResponse();
    }

}
