<?php

namespace AdminBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\User;
use AppBundle\Service\PdfGenerator;
use Proxies\__CG__\AppBundle\Entity\Company;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class AccessibilityRegisterController extends Controller
{
    /**
     * @Route("/admin/register/show/{register_id}", name="register_show")
     */
    public function registerShowAction(Request $request, $register_id)
    {

        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)
            ->findOneBy(
                ['id' => $register_id]
            );
        $types = $register->getErp()->getCategoryErp()->getTypesFile();
        $fileUploads = [];
        foreach($types as $type) {
            $fileUploads[$type->getId()] = $register->getFileUploadsByTypeId($type->getId());
        }

        return $this->render('Admin/AccessibilityRegister/show.html.twig', [
            'register' => $register,
            'types' => $types,
            'fileUploads' => $fileUploads
        ]);
    }

    /**
     * @Route("/admin/register/generate/{register_id}/{from}", name="admin_register_generate")
     */
    public function registerGenerateAction(Request $request, $register_id, $from, PdfGenerator $pdfGenerator)
    {

        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneBy(['id' => $register_id]);

        $types = $register->getErp()->getCategoryErp()->getTypesFile();
        $fileUploads = [];
        foreach($types as $type) {
            $fileUploads[$type->getId()] = $register->getFileUploadsByTypeId($type->getId());
        }

        if($register->getPdf()){
            $this->addFlash('notice', 'Le registre a déjà été généré.');
            return $this->render('Admin/AccessibilityRegister/show.html.twig', [
                'register' => $register,
                'types' => $types,
                'fileUploads' => $fileUploads
            ]);
        }

        $pdfGenerator->generateOnePdf($register);

        if($from == 'print_request_show'){
            $this->addFlash('notice', 'Le registre a bien été généré, vous pouvez désormais choisir un imprimeur et lui transmettre les documents.');
            return $this->redirectToRoute('print_request_show', ['print_request_id' => $register->getPrintRequest()->getId()]);
        }
        return $this->redirectToRoute('register_show', [
            'register' => $register,
            'types' => $types,
            'fileUploads' => $fileUploads
        ]);
    }
}
