INSERT INTO `post` (`id`, `slug`, `content`, `title`)
VALUES
	(2, 'contexte', '<p>Les gestionnaires d’ERP doivent mettre à disposition du public un document, appelé registre public d’accessibilité, afin de communiquer sur le niveau d’accessibilité des prestations proposées par leur établissement.</p>\n\n<p>Le registre, pour être aussi utile qu’efficace se doit d’être simple et compréhensible par tous. Cette simplicité doit également se retrouver dès son élaboration. Il s’agit là en effet d’un outil de communication entre l’ERP et sa clientèle, un moyen de promouvoir la qualité d’un accueil de tous les publics et de l’attention portée à chacun.</p>\n\n<p>Ce guide a pour objectif de présenter et d’expliquer ce qui est attendu par le législateur et de proposer une méthode d’organisation du registre qui, tout en restant simple, lui donnera du sens.</p>\n\n<p>L’accessibilité du registre a été réfléchie et travaillée en concertation avec les associations de personnes handicapées et des représentants des acteurs économiques afin qu’il soit le plus adapté possible aux personnes à qui il s’adresse.</p>\n\n<p>C’est pourquoi il est proposé que le registre soit organisé en deux parties :</p>\n\n<ul>\n	<li>Une fiche informative qui synthétise les informations essentielles.</li>\n	<li>L’ensemble des pièces administratives relatives à l’accessibilité déjà existantes selon la situation de l’ERP (accessible ou non, sous Ad’AP ou pas, dérogation ou non, etc.).</li>\n</ul>\n\n<p>De cette sorte, la personne qui souhaite le consulter pourra, en toute simplicité, ne lire que la fiche synthétique pour obtenir les informations qu’elle recherche. De même, cette fiche, grâce au modèle-type proposé, reste simple à remplir pour le gestionnaire, et lui permettra dans le même temps de répondre à ses obligations tout en y consacrant un temps minimum.</p>\n\n<p><strong><u>Les textes de référence</u></strong></p>	\n\n<p>Décret du 28 mars 2017 relatif au registre public d’accessibilité et modifiant diverses dispositions relatives à l’accessibilité aux personnes handicapées des établissements recevant du public et des installations ouvertes au public.</p>\n\n<p><a href=\"https://www.legifrance.gouv.fr/eli/decret/2017/3/28/LHAX1702913D/jo/texte\" title=\"Décret\">https://www.legifrance.gouv.fr/eli/decret/2017/3/28/LHAX1702913D/jo/texte</a></p>\n\n<p>Arrêté du 19 avril 2017 fixant le contenu et les modalités de diffusion et de mise à jour du registre public d’accessibilité</p>\n\n<a href=\"https://www.legifrance.gouv.fr/eli/arrete/2017/4/19/LHAL1614039A/jo/texte/fr\" title=\"Arrêté du 19 avril 2017\">https://www.legifrance.gouv.fr/eli/arrete/2017/4/19/LHAL1614039A/jo/texte/fr</a>', 'Contexte règlementaire'),
	(3, 'objectifs', '<h6>Sommaire</h6>\n<ul>\n	<li><a href=\"#degre\" title=\"Accéder directement à la partie : Communiquer sur le degré d’accessibilité de son établissement\">Communiquer sur le degré d’accessibilité de son établissement</a></li>\n	<li><a href=\"#niveau-accessibilite\" title=\"Accéder directement à la partie : Communiquer et informer sur le niveau d’accessibilité des prestations proposées\">Communiquer et informer sur le niveau d’accessibilité des prestations proposées</a></li>\n	<li><a href=\"#place-accueil\" title=\"Accéder directement à la partie : La place de l’accueil et de l’accompagnement humain\">La place de l’accueil et de l’accompagnement humain</a></li>\n</ul>\n\n<br /><br />\n<ol>\n	<li id=\"degre\">\n		<h6>Communiquer sur le degré d’accessibilité de son établissement</h6>\n		<p>Les propriétaires et exploitants des établissements recevant du public (ERP) neufs et situés dans un cadre bâti existant, sont tenus de mettre à disposition du public un registre d’accessibilité avant le 30 septembre 2017.</p>\n		<p>Ce registre a pour objectif d’informer le public sur le degré d’accessibilité de l’ERP et de ses prestations. Ainsi, les informations communiquées dans ce document doivent être centrées sur le service rendu et non sur le strict respect de telle ou telle prescription réglementaire. Donner à connaître le degré d’accessibilité de son ERP revient à dire si l’établissement est accessible totalement ou partiellement. S’il l’est partiellement, quelle(s) prestation(s) l’est (le sont) et laquelle (ou lesquelles) ne l’est pas (ne le sont pas)</p>\n		<p><strong>Cette information, surtout si elle est accessible à distance (via un site internet ou par téléphone si une personne appelle) est essentielle pour préparer le déplacement d’une personne handicapée.</strong></p>\n	</li>\n	<li id=\"niveau-accessibilite\">\n		<h6>Communiquer et informer sur le niveau d’accessibilité des prestations proposées</h6>\n		<p>En mettant à disposition du public un registre d’accessibilité conforme à l’arrêté du 19 avril 2017, les propriétaires et exploitants ont ainsi la possibilité d’attester du respect de la loi, de faire connaître mais aussi de valoriser les actions mises en œuvre dans leur établissement en faveur de l’accueil de tous les publics. Ce registre mentionne les dispositions prises pour permettre à tous, notamment aux personnes handicapées, quel que soit leur handicap, de bénéficier des prestations offertes par l’établissement. Une attention particulière doit être apportée au contenu et à la forme afin que les informations communiquées dans le registre soient accessibles à tous et utiles aux personnes principalement concernées.</p>\n	</li>\n	<li id=\"place-accueil\">\n		<h6>La place de l’accueil et de l’accompagnement humain</h6>\n		<p>L’accompagnement humain reste essentiel pour certaines personnes dont l’autonomie complète au sein d’un établissement ne peut être envisagée. La mise en accessibilité passe également par la présence d’un personnel sensibilisé aux différents types de handicaps, formé à l’accueil et à l’accompagnement de tous les publics, connaissant l’attitude à adopter, et soucieux de satisfaire ses visiteurs</p>\n	</li>\n</ol>', 'Objectifs du registre d’accessibilité'),
	(4, 'contenu', '<h6>Sommaire</h6>\n\n<ul>\n	<li><a href=\"#fiche-informative\">Une fiche informative de synthèse</a></li>\n	<li>\n		<a href=\"#explications-contenu-fiche\">Explications sur le contenu de la fiche informative</a>\n		<ul>\n			<li><a href=\"#prestations-offertes\">L’information sur les prestations offertes par l’établissement</a></li>\n			<li><a href=\"#niveau-accessibilite\">L’information sur le niveau d’accessibilité des prestations</a></li>\n			<li><a href=\"#infos-modalites\">Les informations relatives aux modalités de maintenance des équipements d’accessibilité</a></li>\n			<li><a href=\"#infos-formation\">Les informations relatives à la formation du personnel</a></li>\n		</ul>\n	</li>\n	<li><a href=\"#piece-administratives\">Les pièces administratives selon la situation</a></li>\n	<li>\n		<a href=\"#tous-erps\">Pour tous les ERP, y compris les établissements de la 5e catégorie</a>\n		<ul>\n			<li><a href=\"#etablissement-nouveau\">Lorsque l’établissement est nouvellement construit</a></li>\n			<li><a href=\"#etablissement-conforme-regles\">Lorsque l’établissement est conforme aux règles d’accessibilité au 31 décembre 2014</a></li>\n			<li><a href=\"#etablissement-agenda\">Lorsque l’établissement fait l’objet d’un agenda d’accessibilité programmée</a></li>\n			<li><a href=\"#arretes-prefectoraux\">Le cas échéant, les arrêtés préfectoraux accordant les dérogations aux règles d’accessibilité</a></li>\n			<li><a href=\"#explications-autorisation-construire\">Lorsque l’établissement a fait l’objet d’une autorisation de construire, d’aménager ou de modifier un établissement recevant du public</a></li>\n		</ul>\n	</li>\n	<li><a href=\"#erp-cat-1-4\">Pour les ERP de la 1e à la 4e catégorie</a></li>\n	<li><a href=\"#bien-accueillir\">La plaquette « Bien accueillir les personnes handicapées »</a></li>\n</ul>\n<br /><br />\n\n\n<ol>\n	<li>\n		<h6>Une fiche informative de synthèse</h6>\n		<p>Pour faciliter l’information de tous les publics, il est conseillé d’établir une fiche de synthèse comportant l’essentiel des informations pour lequel le registre d’accessibilité a été prévu. En effet, les différentes pièces administratives afférentes à l’état réglementaire de l’établissement, à joindre dans le registre, ne sont pas toujours très accessibles et/ou compréhensibles par tous les usagers.</p>\n	</li>\n	<li>\n		<h6>Explications sur le contenu de la fiche informative</h6>\n		<ol>\n			<li>\n				<h6>L’information sur les prestations offertes par l’établissement</h6>\n				<p>Il s’agit de donner une information, pouvant rester très générale, sur l’activité de l’établissement et les différents services proposés. Pour une activité simple qui contient toutes les informations dans son intitulé, il n’est pas utile d’en dire plus ni de reformuler la prestation. Par contre, pour certains ERP qui, pour une même activité, proposent plusieurs prestations différentes, il est utile de préciser les différents services proposés. Exemple : </p>\n				<ul>\n					<li>Pour une boulangerie, tout est dit dans le terme « boulangerie », lequel contient en lui-même la prestation proposée.</li>\n					<li>Pour une piscine, outre la pratique de la natation, celle-ci peut offrir l’accès à un sauna, à une salle de sport, etc ;</li>\n					<li>Pour un hôtel, outre le service d’hébergement, celui-ci peut comporter un restaurant, des salles de conférence, etc ; </li>\n					<li>Pour un hypermarché, différents types de produits peuvent être proposés, alimentaires, non alimentaires, parapharmacie, etc.</li>\n				</ul>\n				<p>Les prestations peuvent se penser également au fur et à mesure du trajet du public dans l’ERP : l’entrée, le circuit (très court dans une boulangerie, comme très long dans un hypermarché) et ses étapes particulières (douche, cabine d’essayage, caisses de paiement, etc) et la sortie.</p>\n			</li>\n			<li>\n				<h6>L’information sur le niveau d’accessibilité des prestations</h6>\n				<p>Il s’agit de donner la situation d’accessibilité de la ou des prestations vis-à-vis de l’obligation réglementaire mais sans entrer dans le détail des actions mises en œuvre, lequel se retrouve dans les pièces administratives. Pour le cas d’un ERP rendu accessible et ayant déposé une attestation, il suffit de préciser : « toutes les prestations offertes dans mon établissement sont accessibles aux personnes handicapées quel que soit leur handicap ». Pour un établissement pas encore accessible, ayant déposé un Ad’AP, il est utile, pour les personnes concernées, de signaler les points qui ne sont pas encore accessibles ou qui sont sous dérogation en précisant notamment :</p>\n				<ul>\n					<li>la date d’accessibilité prévisionnelle en regard de la programmation des actions y afférentes prévues dans l’Ad’AP ;</li>\n					<li>la date prévisionnelle d’obtention d’une dérogation envisagée dans le cadre de la mise en œuvre de l’Ad’AP.</li>\n				</ul>\n				<p>Signaler les difficultés principales :</p>\n				<p>Outre la description de la prestation offerte par l’établissement, il est utile de signaler les points les plus importants rendant la prestation non accessible : entrée de l’établissement, accès à la prestation, accès au paiement, accès aux sanitaires, etc.</p>\n				<p>Ainsi, la formulation suivante est à la fois simple et efficace : « l’établissement est accessible, exceptées les toilettes qui font l’objet d’une dérogation ».</p>\n				<p>Ne pas oublier la possibilité d’une aide humaine :</p>\n				<p>L’accompagnement du client est un basique du service offert par tout professionnel. Certaines personnes peuvent avoir besoin d’un accompagnement plus important. Certains aménagements peu accessibles, voire inaccessibles en toute autonomie peuvent devenir relativement accessibles, grâce à un accompagnement humain. Par exemple, j’ai obtenu une dérogation pour la marche à l’entrée de mon établissement. Plutôt que de m’en contenter, j’installe une sonnette et propose, à quiconque le souhaite, mon aide pour entrer.</p>\n			</li>\n			<li>\n				<h6>Les informations relatives aux modalités de maintenance des équipements d’accessibilité</h6>\n				<p>Il s’agit de donner les informations relatives à la politique de maintenance mise en œuvre au sein de l’établissement, lorsque celui-ci dispose de ce type d’équipement le nécessitant. Le propriétaire ou le gestionnaire n’a pas à fournir les contrats correspondant ni les modalités techniques prévues par ceux-ci.</p>\n				<p>Il est notamment utile :</p>\n				<ul>\n					<li>de préciser si ces équipements font l’objet d’une maintenance ;</li>\n					<li>de préciser que le personnel est formé à l’utilisation des équipements ;</li>\n					<li>de donner les modalités d’utilisation des équipements d’accessibilité par le personnel (par exemple, pour une rampe amovible manuelle : une fois que quelqu’un a signalé sa présence à l’entrée grâce à la sonnette, un(e) vendeur(se) disponible déploie la rampe pour le faire entrer) ;</li>\n					<li>d’éventuellement y conserver les notices et modes d’emploi des équipements.</li>\n				</ul>\n				<p>Pour les équipements nécessitant un entretien régulier, un exemple de fiche de suivi est disponible.</p>\n				<p>Exemples d’équipement nécessitant une maintenance : </p>\n				<ul>\n					<li>groom ;</li>\n					<li>porte automatique ;</li>\n					<li>rampe d’accès ; </li>\n					<li>ascenseur ou élévateur ; </li>\n					<li>boucle à induction magnétique ; </li>\n					<li>balise sonore ;</li>\n					<li>signalétique sur écran ; </li>\n					<li>tourniquet ;</li>\n					<li>tapis roulant ou escalier mécanique.</li>\n				</ul>\n			</li>\n			<li>\n				<h6>Les informations relatives à la formation du personnel </h6>\n				<p>Il s’agit d’informer sur ce qui est prévu par le gestionnaire en matière de sensibilisation et/ou de formation à l’accueil des personnes handicapées ainsi qu’à l’utilisation des équipements d’accessibilité. </p>\n				<p><strong>Pour les ERP les plus importants, notamment ceux pouvant accueillir plus de 200 personnes et donc soumis à une obligation de formation</strong> : le type d’action de formation mise en place annuellement, que ce soit au moment de la prise de poste ou en cours d’emploi. Cette formation peut être faite en présentiel ou à distance, en groupe ou individuellement. L’attestation est signée par l’employeur et accompagnée des justificatifs de formation.</p>\n				<p><strong>Pour les ERP de 5e catégorie</strong> : a sensibilisation à minima des personnels en contact avec le public via la connaissance de la plaquette d’aide à l’accueil des personnes handicapées</p>\n			</li>\n		</ol>\n	</li>\n	<li>\n		<h6>Les pièces administratives selon la situation</h6>\n		<p>Ces documents constituent la partie administrative du registre. Ils ont tous déjà été produits par le gestionnaire, à l’occasion soit de l’ouverture de son ERP, soit du dépôt de son Ad’AP, soit de la réalisation de travaux antérieurs, etc, ou bien ont été fournis par l’administration, tel un arrêté préfectoral approuvant une dérogation, par exemple. Il suffit donc d’en effectuer des copies et de les ajouter au registre.</p>\n		<ol>\n			<li>\n				<h6>Pour tous les ERP, y compris les établissements de la 5e catégorie</h6>\n				<p><strong>1° Lorsque l’établissement est nouvellement construit, l’attestation prévue par l’article L. 111-7-4 après achèvement des travaux ;</strong></p>\n				<p>Pour ceux construits entre 2014 et aujourd’hui : Attestation établie par un contrôleur technique, ou un architecte, (selon le modèle de l’annexe 1 de l’arrêté du 22 mars 2007)</p>\n				<p><strong>2° Lorsque l’établissement est conforme aux règles d’accessibilité au 31 décembre 2014, l’attestation d’accessibilité prévue à l’article R. 111-19-33 ;</strong></p>\n				<p>Attestation sur l’honneur pour les 5e catégorie. Pour les 1e à 4e catégories il s’agit d’une attestation établie par un contrôleur technique. La pièce prévue au 1° (attestation d’achèvement des travaux) peut être utilisée dans le cas d’un ERP construit entre 2007 et aujourd’hui.</p>\n				<p><strong>3° Lorsque l’établissement fait l’objet d’un agenda d’accessibilité programmée conformé- ment aux articles R. 111-19-31 à R. 111-19-47 :</strong></p>\n				<ul>\n					<li>le calendrier de la mise en accessibilité de l’établissement : préciser les dates de dé- but et de fin prévisionnelle de l’agenda ;</li>\n					<li>pour les agendas de plus de trois ans : joindre le bilan à mi-parcours prévu à l’article D. 111-19-45 du CCH, une fois qu’il est réalisé ;</li>\n					<li>l’attestation d’achèvement prévue à l’article D. 111-19-46 du CCH, à la fin de l’agenda. Réalisée par le gestionnaire, sur l’honneur pour les ERP de 5e catégorie, ou par un contrôleur agréé ou un architecte pour les ERP de 1ère à 4e catégorie.</li>\n				</ul>\n				<p>Il s’agit de l’attestation d’achèvement de l’Ad’AP, dans le cas d’Ad’AP de patrimoine, elle est réalisée une fois l’ensemble des travaux ou aménagements de mise en accessibilité est achevé. Attestation sur l’honneur pour la 5e catégorie.</p>\n				<p><strong>4° Le cas échéant, les arrêtés préfectoraux accordant les dérogations aux règles d’accessibilité mentionnées à l’article R. 111-19-10, ou, à défaut en cas d’acceptation tacite, le récépissé de dépôt de l’AT contenant la demande de dérogation ;</strong></p>\n				<p>En cas d’approbation tacite, le récépissé de dépôt du dossier Ad’AP, accompagné d’une copie de la demande de dérogation, font foi. En cas d’absence de récépissé de dépôt, se reporter au tableau de suivi des ERP accessibles ou sous Ad’AP mis en ligne sur le site de la préfecture.</p>\n				<p><strong>5° Lorsque l’établissement a fait l’objet d’une autorisation de construire, d’aménager ou de modifier un établissement recevant du public, la notice d’accessibilité prévue à l’article D. 111-19-18 ;</strong></p>\n				<p>La notice d’accessibilité est produite au moment du dépôt de la demande d’autorisation de construire.</p>\n			</li>\n			<li>\n				<h6>Pour les ERP de la 1e à la 4e catégorie</h6>\n				<p>En plus des éléments mentionnés précédemment, le registre public d’accessibilité contient une attestation signée et mise à jour annuellement par l’employeur décrivant les actions de formation des personnels chargés de l’accueil des personnes handicapées et leurs justificatifs. Lorsque le personnel chargé de l’accueil des personnes handicapées est affecté à plusieurs établissements, cette attestation peut être réalisée pour l’ensemble des établissements concernés.</p>\n			</li>\n		</ol>\n	</li>\n	<li>\n		<h6>La plaquette « Bien accueillir les personnes handicapées »</h6>\n		<p>Cette plaquette a été réalisée par la délégation ministérielle à l’accessibilité, en concertation avec les associations de personnes handicapés et les représentants des acteurs économiques. Elle donne des conseils sur la bonne attitude à adopter pour l’accueil des personnes handicapées quel que soit leur type de handicap. </p>\n	</li>\n</ol>', 'Contenu du registre d’accessibilité');
